#pragma rtGlobals=1		// Use modern global access method.

#include "PreTreatmentCommand"
#include "PreTreatmentGraph"

//---------------------------------------------------------------------------------------------------------------
//---------------------------------------------------------------------------------------------------------------
//---------------------------------------------------------------------------------------------------------------

Window PreTreatmentPanel() : Panel
	Silent 1;
	NewPanel /W=(384,147,812,707) as "Pre-Treatment Panel"
	ModifyPanel cbRGB=(65534,65534,65534)
	SetDrawLayer UserBack
	SetDrawEnv fillfgc= (38400,39424,49664)
	DrawRect 500,-2,-1,591
	SetDrawEnv fillfgc= (30720,27648,56576)
	DrawRect 418,546,9,436
	TabControl TabPreTreatmentPanel win = PreTreatmentPanel,pos={8,7},size={412,539},proc=TabPreTreatmentPanelProc
	TabControl TabPreTreatmentPanel win = PreTreatmentPanel,tabLabel(0)="Filter/Graph.",tabLabel(1)="Electron Param."
	TabControl TabPreTreatmentPanel win = PreTreatmentPanel,tabLabel(2)="Ion Param.",tabLabel(3)="Det. Param.",value= 0
	PopupMenu IsCoincF_e win = PreTreatmentPanel,pos={22,65},size={150,21},disable=1,proc=PopMenuFilter,title="Coincidence Degree"
	PopupMenu IsCoincF_e win = PreTreatmentPanel,mode=1
	

	PopupMenu Filter_e win = PreTreatmentPanel,pos={27,133},size={134,21},disable=1,proc=PopMenuFilter,title="Select Filters"
	PopupMenu Filter_e win = PreTreatmentPanel,mode=1,popvalue="Time",value= #"\"Time;Spatial X;Spatial Y;Radius; Angle \""
	GroupBox Filters_e win = PreTreatmentPanel,pos={16,36},size={394,71},disable=1,title="Active Filters"
	CheckBox IsTimeF_e win = PreTreatmentPanel,pos={202,69},size={41,14},disable=1,proc=CheckFilter,title="Time"
	CheckBox IsSpatialXF_e win = PreTreatmentPanel,pos={258,57},size={60,14},disable=1,proc=CheckFilter,title="Spatial X"
	CheckBox IsSpatialYF_e win = PreTreatmentPanel,pos={258,83},size={60,14},disable=1,proc=CheckFilter,title="Spatial Y"
	CheckBox IsAngleF_e win = PreTreatmentPanel,pos={338,83},size={45,14},disable=1,proc=CheckFilter,title="Angle"
	CheckBox IsRadiusF_e win = PreTreatmentPanel,pos={338,57},size={51,14},disable=1,proc=CheckFilter,title="Radius"
	SetVariable MinVal_e1 win = PreTreatmentPanel,pos={35,161},size={175,16},disable=1,title="Electron 1 : Min. Value"
	SetVariable MinVal_e2 win = PreTreatmentPanel,pos={35,183},size={175,16},disable=1,title="Electron 2 : Min. Value"
	SetVariable MinVal_e3 win = PreTreatmentPanel,pos={35,205},size={175,16},disable=1,title="Electron 3 : Min. Value"
	SetVariable MinVal_e4 win = PreTreatmentPanel,pos={35,227},size={175,16},disable=1,title="Electron 4 : Min. Value"
	SetVariable MaxVal_e1 win = PreTreatmentPanel,pos={261,161},size={120,16},disable=1,title="Max. Value"
	SetVariable MaxVal_e2 win = PreTreatmentPanel,pos={261,183},size={120,16},disable=1,title="Max. Value"
	SetVariable MaxVal_e3 win = PreTreatmentPanel,pos={261,206},size={120,16},disable=1,title="Max. Value"
	SetVariable MaxVal_e4 win = PreTreatmentPanel,pos={261,227},size={120,16},disable=1,title="Max. Value"
	Button SetF_e win = PreTreatmentPanel,pos={158,251},size={100,20},disable=1,proc=ButtonFilter,title="Store values"
	SetVariable OutWave_e win = PreTreatmentPanel,pos={62,369},size={300,16},disable=1,title="Output Wave Name"
	SetVariable OutWave_e win = PreTreatmentPanel,value= root:PreTreatmentParam:OutWaveElec
	Button CalculeFilter_e win = PreTreatmentPanel,pos={134,485},size={150,30},disable=1,proc=ButtonFilter,title="Filter Electrons"
	PopupMenu Combine_e win = PreTreatmentPanel,pos={159,393},size={108,21},disable=1,proc=PopMenuFilter,title="Operation"
	PopupMenu Combine_e win = PreTreatmentPanel,mode=3,popvalue="Or",value= #"\"Default;And;Or;Comp;\""
	GroupBox Misc_e win = PreTreatmentPanel,pos={16,341},size={393,85},disable=1,title="Misc. Operation"
	GroupBox ChangeFilter_e win = PreTreatmentPanel,pos={16,112},size={394,166},disable=1,title="Filter Parameters"
	CheckBox Filter_ee win = PreTreatmentPanel,pos={56,457},size={105,14},disable=1,proc=CheckFilter,title="Use Electron Data"
	CheckBox Filter_ei win = PreTreatmentPanel,pos={283,457},size={81,14},disable=1,proc=CheckFilter,title="Use Ion Data"
	GroupBox ChangeFilter_i win = PreTreatmentPanel,pos={16,112},size={394,166},disable=1,title="Filter Parameters"
	GroupBox Misc_i win = PreTreatmentPanel,pos={16,341},size={394,85},disable=1,title="Misc. Operation"
	GroupBox Filters_i win = PreTreatmentPanel,pos={16,36},size={394,71},disable=1,title="Active Filters"
	PopupMenu IsCoincF_i win = PreTreatmentPanel,pos={22,66},size={150,21},disable=1,proc=PopMenuFilter,title="Coincidence Degree"
	PopupMenu IsCoincF_i win = PreTreatmentPanel,mode=1,popvalue="All",value= #"\"All;1;2;3;4\""
	CheckBox IsTimeF_i win = PreTreatmentPanel,pos={202,69},size={41,14},disable=1,proc=CheckFilter,title="Time"
	CheckBox IsSpatialXF_i win = PreTreatmentPanel,pos={258,57},size={60,14},disable=1,proc=CheckFilter,title="Spatial X"
	CheckBox IsSpatialYF_i win = PreTreatmentPanel,pos={258,83},size={60,14},disable=1,proc=CheckFilter,title="Spatial Y"
	CheckBox IsRadiusF_i win = PreTreatmentPanel,pos={338,57},size={51,14},disable=1,proc=CheckFilter,title="Radius"
	CheckBox IsAngleF_i win = PreTreatmentPanel,pos={338,83},size={45,14},disable=1,proc=CheckFilter,title="Angle"
	PopupMenu Filter_i win = PreTreatmentPanel,pos={27,133},size={134,21},disable=1,proc=PopMenuFilter,title="Select Filters"
	PopupMenu Filter_i win = PreTreatmentPanel,mode=1,popvalue="Time",value= #"\"Time;Spatial X;Spatial Y;Radius; Angle \""
	SetVariable MinVal_i1 win = PreTreatmentPanel,pos={35,161},size={175,16},disable=1,title="Ion 1 : Min. Value"
	SetVariable MinVal_i2 win = PreTreatmentPanel,pos={35,183},size={175,16},disable=1,title="Ion 2 : Min. Value"
	SetVariable MinVal_i3 win = PreTreatmentPanel,pos={35,205},size={175,16},disable=1,title="Ion 3 : Min. Value"
	SetVariable MinVal_i4 win = PreTreatmentPanel,pos={35,227},size={175,16},disable=1,title="Ion 4 : Min. Value"
	Button SetF_i win = PreTreatmentPanel,pos={158,251},size={100,20},disable=1,proc=ButtonFilter,title="Store values"
	SetVariable MaxVal_i4 win = PreTreatmentPanel,pos={261,227},size={120,16},disable=1,title="Max. Value"
	SetVariable MaxVal_i3 win = PreTreatmentPanel,pos={261,206},size={120,16},disable=1,title="Max. Value"
	SetVariable MaxVal_i2 win = PreTreatmentPanel,pos={261,183},size={120,16},disable=1,title="Max. Value"
	SetVariable MaxVal_i1 win = PreTreatmentPanel,pos={261,161},size={120,16},disable=1,title="Max. Value"
	PopupMenu Combine_i win = PreTreatmentPanel,pos={159,393},size={131,21},disable=1,proc=PopMenuFilter,title="Operation"
	PopupMenu Combine_i win = PreTreatmentPanel,mode=1,popvalue="Default",value= #"\"Default;And;Or;Comp;\""
	SetVariable OutWave_i win = PreTreatmentPanel,pos={62,369},size={300,16},disable=1,title="Output Wave Name"
	SetVariable OutWave_i win = PreTreatmentPanel,value= root:PreTreatmentParam:OutWaveIon
	CheckBox Filter_ie win = PreTreatmentPanel,pos={56,457},size={105,14},disable=1,proc=CheckFilter,title="Use Electron Data"
	CheckBox Filter_ii win = PreTreatmentPanel,pos={283,457},size={81,14},disable=1,proc=CheckFilter,title="Use Ion Data"
	Button CalculeFilter_i win = PreTreatmentPanel,pos={134,485},size={150,30},disable=1,proc=ButtonFilter,title="Filter Ions"
	GroupBox Image_i win = PreTreatmentPanel,pos={16,284},size={394,51},disable=1,title="Image Center"
	SetVariable Xg_i win = PreTreatmentPanel,pos={33,308},size={150,16},disable=1,title="Center X (Channel)"
	SetVariable Xg_i win = PreTreatmentPanel,value= root:PreTreatmentParam:CenterX_i
	SetVariable Yg_i win = PreTreatmentPanel,pos={247,309},size={150,16},disable=1,title="Center Y (Channel)"
	SetVariable Yg_i win = PreTreatmentPanel,value= root:PreTreatmentParam:CenterY_i
	GroupBox Image_e win = PreTreatmentPanel,pos={16,284},size={394,51},disable=1,title="Image Center"
	SetVariable Xg_e win = PreTreatmentPanel,pos={33,308},size={150,16},disable=1,title="Center X (Channel)"
	SetVariable Xg_e win = PreTreatmentPanel,value= root:PreTreatmentParam:CenterX_e
	SetVariable Yg_e win = PreTreatmentPanel,pos={247,309},size={150,16},disable=1,title="Center Y (Channel)"
	SetVariable Yg_e win = PreTreatmentPanel,value= root:PreTreatmentParam:CenterY_e
	CheckBox IsMultiCoinF_e win = PreTreatmentPanel,pos={261,139},size={101,14},disable=1,proc=CheckFilter,title="Multi-hit treatment"
	CheckBox IsMultiCoinF_i win = PreTreatmentPanel,pos={261,139},size={101,14},disable=1,proc=CheckFilter,title="Multi-hit treatment"

	Button CalculeFilter win = PreTreatmentPanel,pos={140,200},size={150,30},proc=ButtonFilter,title="Filter Electrons-Ions"
	CheckBox AutoFetch win = PreTreatmentPanel,pos={142,244},size={144,14},proc=CheckFilter,title="Auto Fetch Data in Waves"
	CheckBox  AutoFetch win = PreTreatmentPanel,value= 1
	CheckBox  AutoRefresh win = PreTreatmentPanel,pos={75,495},size={80,14},proc=CheckFilter,title="Auto Refresh"
	CheckBox  AutoRefresh win = PreTreatmentPanel,value= 0
	Button PlotEvents win = PreTreatmentPanel ,pos={256,450},size={150,20},proc=ButtonFilter,title="Display/Hide Graph"
	Button PlotRefresh win = PreTreatmentPanel ,pos={39,448},size={150,30},proc=ButtonFilter,title="Refresh Graph"
	Button HidePanel win = PreTreatmentPanel,pos={256,497},size={150,20},proc=ButtonFilter,title="Hide Panel"	

	GroupBox Filters_i01 win = PreTreatmentPanel,disable=1,pos={16,36},size={396,264},title="Fetch Data with correction"
	GroupBox Offset_e win = PreTreatmentPanel,disable=1,pos={26,64},size={177,170},title="Electron Offset "
	SetVariable Xg_e01 win = PreTreatmentPanel,disable=1,pos={40,91},size={150,15},title="Center X (Channel)"
	SetVariable Xg_e01 win = PreTreatmentPanel,disable=1,value= root:PreTreatmentParam:CenterX_e
	SetVariable Yg_e01 win = PreTreatmentPanel,disable=1,pos={39,119},size={150,15},title="Center Y (Channel)"
	SetVariable Yg_e01 win = PreTreatmentPanel,disable=1,value= root:PreTreatmentParam:CenterY_e
	GroupBox Offset_i win = PreTreatmentPanel,disable=1,pos={221,64},size={177,170},title="Ion Offset "
	SetVariable Xg_i01 win = PreTreatmentPanel,disable=1,pos={237,91},size={150,15},title="Center X (Channel)"
	SetVariable Xg_i01 win = PreTreatmentPanel,disable=1,value= root:PreTreatmentParam:CenterX_i
	SetVariable Yg_i01 win = PreTreatmentPanel,disable=1,pos={237,119},size={150,15},title="Center Y (Channel)"
	SetVariable Yg_i01 win = PreTreatmentPanel,disable=1,value= root:PreTreatmentParam:CenterY_i
	SetVariable Rotation_e win = PreTreatmentPanel,disable=1,pos={39,145},size={150,15},title="Rotation (Degree)  "
	SetVariable Rotation_e win = PreTreatmentPanel,disable=1,value= root:PreTreatmentParam:Rotation_e
	SetVariable Rotation_i win = PreTreatmentPanel,disable=1,pos={237,145},size={150,15},title="Rotation (Degree)  "
	SetVariable Rotation_i win = PreTreatmentPanel,disable=1,value= root:PreTreatmentParam:Rotation_i
	Button disp_e win = PreTreatmentPanel,disable=1,pos={70,188},size={100,20},title="Display Electron"
	Button disp_i win = PreTreatmentPanel,disable=1,pos={260,188},size={100,20},title="Display Ion"
	Button Fetch_ei win = PreTreatmentPanel,disable=1,disable=1,pos={166,256},size={100,20},title="Fetch All in One"
	GroupBox Misc win = PreTreatmentPanel ,disable=1,pos={16,341},size={393,85},disable=1,title="Misc. Operation"
	Button SaveFilter win = PreTreatmentPanel ,pos={133,394},size={150,20},disable=1,proc=ButtonFilter,title="Save Filter Parameters"
	SetVariable  OutFolder win = PreTreatmentPanel,pos={62,369},size={300,15},disable=1,title="Save Filter Parameters"	
	
	InitPreTreatmentWidgets()
	

	
	
EndMacro

//------------------------------------------------------------------------------------
Proc InitPreTreatmentWidgets()
	Variable Dummy
	Silent 1;
	TabControl TabPreTreatmentPanel win = PreTreatmentPanel,proc=TabPreTreatmentPanelProc
	
	// Filter/Graph
	Button CalculeFilter win = PreTreatmentPanel, proc=ButtonFilter 
	CheckBox AutoFetch win = PreTreatmentPanel ,proc=CheckFilter, variable =root:PreTreatmentParam:AutoFetch, value=(!!(root:PreTreatmentParam:AutoFetch))
	CheckBox AutoRefresh win = PreTreatmentPanel ,proc=CheckFilter,variable = root:PreTreatmentParam:AutoRefresh, value=(!!(root:PreTreatmentParam:AutoRefresh))
	Button PlotEvents win = PreTreatmentPanel ,proc=ButtonFilter
	Button PlotRefresh win = PreTreatmentPanel ,proc=ButtonFilter
	Button HidePanel win = PreTreatmentPanel,proc=ButtonFilter	
	
	// Tab Electrons
	PopupMenu IsCoincF_e win = PreTreatmentPanel, proc=PopMenuFilter,mode=root:PreTreatmentParam:multiplicity_e+1,value= #"\"All;1;2;3;4\""
	CheckBox IsTimeF_e win = PreTreatmentPanel,proc=CheckFilter,value= (!!((root:PreTreatmentParam:FilterType_e)%&(2^1)))
	CheckBox IsSpatialXF_e win = PreTreatmentPanel,proc=CheckFilter,value=(!!((root:PreTreatmentParam:FilterType_e)%&(2^2)))
	CheckBox IsSpatialYF_e win = PreTreatmentPanel,proc=CheckFilter,value= (!!((root:PreTreatmentParam:FilterType_e)%&(2^3)))
	CheckBox IsRadiusF_e win = PreTreatmentPanel,proc=CheckFilter,value= (!!((root:PreTreatmentParam:FilterType_e)%&(2^4)))
	CheckBox IsAngleF_e win = PreTreatmentPanel,proc=CheckFilter,value= (!!((root:PreTreatmentParam:FilterType_e)%&(2^5)))
	
	PopupMenu Filter_e win = PreTreatmentPanel,proc=PopMenuFilter, popvalue="Time",value= #"\"Time;Spatial X;Spatial Y;Radius; Angle \""
	CheckBox IsMultiCoinF_e win = PreTreatmentPanel,proc=CheckFilter, value=(!!((root:PreTreatmentParam:FilterType_e)%&(2^7)))
	SetVariable MinVal_e1 win = PreTreatmentPanel,value= root:PreTreatmentParam:MinVal_e[0]
	SetVariable MinVal_e2 win = PreTreatmentPanel,value= root:PreTreatmentParam:MinVal_e[1]
	SetVariable MinVal_e3 win = PreTreatmentPanel,value= root:PreTreatmentParam:MinVal_e[2]
	SetVariable MinVal_e4 win = PreTreatmentPanel,value= root:PreTreatmentParam:MinVal_e[3]
	SetVariable MaxVal_e1 win = PreTreatmentPanel,value= root:PreTreatmentParam:MaxVal_e[0]
	SetVariable MaxVal_e2 win = PreTreatmentPanel,value= root:PreTreatmentParam:MaxVal_e[1]
	SetVariable MaxVal_e3 win = PreTreatmentPanel,value= root:PreTreatmentParam:MaxVal_e[2]
	SetVariable MaxVal_e4 win = PreTreatmentPanel,value= root:PreTreatmentParam:MaxVal_e[3]
	Button SetF_e win = PreTreatmentPanel,proc=ButtonFilter
	
	SetVariable Xg_e win = PreTreatmentPanel,value= root:PreTreatmentParam:CenterX_e
	SetVariable Yg_e win = PreTreatmentPanel,value= root:PreTreatmentParam:CenterY_e
	
	Dummy=1+!!(root:PreTreatmentParam:FilterOption_e&2)+2*(!!(root:PreTreatmentParam:FilterOption_e&4))+3*(!!(root:PreTreatmentParam:FilterOption_e&8))
	PopupMenu Combine_e win = PreTreatmentPanel,proc=PopMenuFilter, mode=Dummy,value= #"\"Default;And;Or;Comp;\""
	SetVariable OutWave_e win = PreTreatmentPanel,value= root:PreTreatmentParam:OutWaveElec
	CheckBox Filter_ee win =PreTreatmentPanel, proc=CheckFilter,value= (!!((root:PreTreatmentParam:FilterOption_e)%&(2^6)))
	CheckBox Filter_ei win = PreTreatmentPanel,proc=CheckFilter,value=(!!((root:PreTreatmentParam:FilterOption_e)%&(2^7)))
	Button CalculeFilter_e win = PreTreatmentPanel,proc=ButtonFilter
	
	// Tab Ions
	PopupMenu IsCoincF_i win = PreTreatmentPanel,proc=PopMenuFilter,mode=root:PreTreatmentParam:multiplicity_i+1,value= #"\"All;1;2;3;4\""
	CheckBox IsTimeF_i win = PreTreatmentPanel,proc=CheckFilter,value= (!!((root:PreTreatmentParam:FilterType_i)%&(2^1)))
	CheckBox IsSpatialXF_i win = PreTreatmentPanel,proc=CheckFilter,value=(!!((root:PreTreatmentParam:FilterType_i)%&(2^2)))
	CheckBox IsSpatialYF_i win = PreTreatmentPanel,proc=CheckFilter,value= (!!((root:PreTreatmentParam:FilterType_i)%&(2^3)))
	CheckBox IsRadiusF_i win = PreTreatmentPanel,proc=CheckFilter,value= (!!((root:PreTreatmentParam:FilterType_i)%&(2^4)))
	CheckBox IsAngleF_i win = PreTreatmentPanel,proc=CheckFilter,value= (!!((root:PreTreatmentParam:FilterType_i)%&(2^5)))
	
	PopupMenu Filter_i win = PreTreatmentPanel,proc=PopMenuFilter,popvalue="Time",value= #"\"Time;Spatial X;Spatial Y;Radius; Angle \""
	CheckBox IsMultiCoinF_i win = PreTreatmentPanel,proc=CheckFilter,value= (!!((root:PreTreatmentParam:FilterType_i)%&(2^7)))
	SetVariable MinVal_i1 win = PreTreatmentPanel,value= root:PreTreatmentParam:MinVal_i[0]
	SetVariable MinVal_i2 win = PreTreatmentPanel,value= root:PreTreatmentParam:MinVal_i[1]
	SetVariable MinVal_i3 win = PreTreatmentPanel,value= root:PreTreatmentParam:MinVal_i[2]
	SetVariable MinVal_i4 win = PreTreatmentPanel,value= root:PreTreatmentParam:MinVal_i[3]
	SetVariable MaxVal_i1 win = PreTreatmentPanel,value= root:PreTreatmentParam:MaxVal_i[0]
	SetVariable MaxVal_i2 win = PreTreatmentPanel,value= root:PreTreatmentParam:MaxVal_i[1]
	SetVariable MaxVal_i3 win = PreTreatmentPanel,value= root:PreTreatmentParam:MaxVal_i[2]
	SetVariable MaxVal_i4 win = PreTreatmentPanel,value= root:PreTreatmentParam:MaxVal_i[3]
	Button SetF_i win = PreTreatmentPanel,proc=ButtonFilter

	SetVariable Xg_i win = PreTreatmentPanel,value= root:PreTreatmentParam:CenterX_i
	SetVariable Yg_i win = PreTreatmentPanel,value= root:PreTreatmentParam:CenterY_i
	
	Dummy=1+!!(root:PreTreatmentParam:FilterOption_i&2)+2*(!!(root:PreTreatmentParam:FilterOption_i&4))+3*(!!(root:PreTreatmentParam:FilterOption_i&8))
	PopupMenu Combine_i win = PreTreatmentPanel,proc=PopMenuFilter, mode=Dummy,value= #"\"Default;And;Or;Comp;\""
	SetVariable OutWave_i win = PreTreatmentPanel,value= root:PreTreatmentParam:OutWaveIon
	CheckBox Filter_ii win = PreTreatmentPanel,proc=CheckFilter,value=  (!!((root:PreTreatmentParam:FilterOption_i)%&(2^6)))
	CheckBox Filter_ie win = PreTreatmentPanel,proc=CheckFilter,value=  (!!((root:PreTreatmentParam:FilterOption_i)%&(2^7)))
	Button CalculeFilter_i win = PreTreatmentPanel, proc=ButtonFilter

	Button CalculeFilter win = PreTreatmentPanel,proc=ButtonFilter
	Button SaveFilter win = PreTreatmentPanel,proc=ButtonFilter
	
	Button disp_e win = PreTreatmentPanel,proc=ButtonFilter
	Button disp_i win = PreTreatmentPanel,proc=ButtonFilter
	Button Fetch_ei win = PreTreatmentPanel,proc=ButtonFilter
EndMacro

//------------------------------------------------------------------------------------
//------------------------------------------------------------------------------------
Function TabPreTreatmentPanelProc(name,tab)
	String name
	Variable tab

	Button CalculeFilter win = PreTreatmentPanel,disable= (tab!=0)
	CheckBox AutoFetch win = PreTreatmentPanel ,disable= (tab!=0)
	CheckBox AutoRefresh win = PreTreatmentPanel,disable= (tab!=0)
	Button PlotEvents win = PreTreatmentPanel ,disable= (tab!=0)
	Button PlotRefresh win = PreTreatmentPanel ,disable= (tab!=0)
	Button HidePanel win = PreTreatmentPanel,disable= (tab!=0)
	
	
	PopupMenu IsCoincF_e win = PreTreatmentPanel,disable= (tab!=1)
	CheckBox IsMultiCoinF_e win = PreTreatmentPanel, disable= (tab!=1)
	PopupMenu Filter_e win = PreTreatmentPanel,disable= (tab!=1)
	GroupBox Filters_e win = PreTreatmentPanel,disable= (tab!=1)
	CheckBox IsTimeF_e win = PreTreatmentPanel,disable= (tab!=1)
	CheckBox IsSpatialXF_e win = PreTreatmentPanel,disable= (tab!=1)
	CheckBox IsSpatialYF_e win = PreTreatmentPanel,disable= (tab!=1)	
	CheckBox IsAngleF_e win = PreTreatmentPanel,disable= (tab!=1)
	CheckBox IsRadiusF_e win = PreTreatmentPanel,disable= (tab!=1)
	SetVariable MinVal_e1 win = PreTreatmentPanel,disable= (tab!=1)
	SetVariable MinVal_e2 win = PreTreatmentPanel,disable= (tab!=1)
	SetVariable MinVal_e3 win = PreTreatmentPanel,disable= (tab!=1)
	SetVariable MinVal_e4 win = PreTreatmentPanel,disable= (tab!=1)
	SetVariable MaxVal_e1 win = PreTreatmentPanel,disable= (tab!=1)
	SetVariable MaxVal_e2 win = PreTreatmentPanel,disable= (tab!=1)
	SetVariable MaxVal_e3 win = PreTreatmentPanel,disable= (tab!=1)
	SetVariable MaxVal_e4 win = PreTreatmentPanel,disable= (tab!=1)
	Button SetF_e win = PreTreatmentPanel,disable= (tab!=1)
	SetVariable OutWave_e win = PreTreatmentPanel,disable= (tab!=1)
	Button CalculeFilter_e win = PreTreatmentPanel,disable= (tab!=1)
	PopupMenu Combine_e win = PreTreatmentPanel,disable= (tab!=1)
	GroupBox Misc_e win = PreTreatmentPanel,disable= (tab!=1)
	CheckBox Filter_ee win = PreTreatmentPanel,disable= (tab!=1)
	CheckBox Filter_ei win = PreTreatmentPanel,disable= (tab!=1)
	GroupBox ChangeFilter_e win = PreTreatmentPanel,disable= (tab!=1)
	GroupBox Image_e win = PreTreatmentPanel,disable= (tab!=1)
	SetVariable Xg_e win = PreTreatmentPanel,disable= (tab!=1)
	SetVariable Yg_e win = PreTreatmentPanel,disable= (tab!=1)
	
	
	GroupBox ChangeFilter_i win = PreTreatmentPanel,disable= (tab!=2)
	GroupBox Misc_i win = PreTreatmentPanel,disable= (tab!=2)
	GroupBox Filters_i win = PreTreatmentPanel,disable= (tab!=2)
	PopupMenu IsCoincF_i win = PreTreatmentPanel,disable= (tab!=2)
	CheckBox IsMultiCoinF_i win = PreTreatmentPanel,disable= (tab!=2)
	CheckBox IsTimeF_i win = PreTreatmentPanel,disable= (tab!=2)
	CheckBox IsSpatialXF_i win = PreTreatmentPanel,disable= (tab!=2)
	CheckBox IsSpatialYF_i win = PreTreatmentPanel,disable= (tab!=2)
	CheckBox IsRadiusF_i win = PreTreatmentPanel,disable= (tab!=2)
	CheckBox IsAngleF_i win = PreTreatmentPanel,disable= (tab!=2)
	PopupMenu Filter_i win = PreTreatmentPanel,disable= (tab!=2)
	SetVariable MinVal_i1 win = PreTreatmentPanel,disable= (tab!=2)
	SetVariable MinVal_i2 win = PreTreatmentPanel,disable= (tab!=2)
	SetVariable MinVal_i3 win = PreTreatmentPanel,disable= (tab!=2)
	SetVariable MinVal_i4 win = PreTreatmentPanel,disable= (tab!=2)
	Button SetF_i win = PreTreatmentPanel,disable= (tab!=2)
	SetVariable MaxVal_i4 win = PreTreatmentPanel,disable= (tab!=2)
	SetVariable MaxVal_i3 win = PreTreatmentPanel,disable= (tab!=2)
	SetVariable MaxVal_i2 win = PreTreatmentPanel,disable= (tab!=2)
	SetVariable MaxVal_i1 win = PreTreatmentPanel,disable= (tab!=2)
	GroupBox Image_i win = PreTreatmentPanel,disable= (tab!=2)	
	SetVariable Xg_i win = PreTreatmentPanel,disable= (tab!=2)
	SetVariable Yg_i win = PreTreatmentPanel,disable= (tab!=2)
	PopupMenu Combine_i win = PreTreatmentPanel,disable= (tab!=2)
	SetVariable OutWave_i win = PreTreatmentPanel,disable= (tab!=2)
	CheckBox Filter_ie win = PreTreatmentPanel,disable= (tab!=2)
	CheckBox Filter_ii win = PreTreatmentPanel,disable= (tab!=2)
	Button CalculeFilter_i win = PreTreatmentPanel,disable= (tab!=2)

	GroupBox Filters_i01 win = PreTreatmentPanel,disable= (tab!=3)
	GroupBox Offset_e win = PreTreatmentPanel,disable= (tab!=3)
	SetVariable Xg_e01 win = PreTreatmentPanel,disable= (tab!=3)
	SetVariable Yg_e01 win = PreTreatmentPanel,disable= (tab!=3)
	GroupBox Offset_i win = PreTreatmentPanel,disable= (tab!=3)
	SetVariable Xg_i01 win = PreTreatmentPanel,disable= (tab!=3)
	SetVariable Yg_i01 win = PreTreatmentPanel,disable= (tab!=3)
	SetVariable Rotation_e win = PreTreatmentPanel,disable= (tab!=3)
	SetVariable Rotation_i win = PreTreatmentPanel,disable= (tab!=3)
	Button disp_e win = PreTreatmentPanel,disable= (tab!=3)
	Button disp_i win = PreTreatmentPanel,disable= (tab!=3)
	Button Fetch_ei win = PreTreatmentPanel,disable= (tab!=3)
	GroupBox Misc win = PreTreatmentPanel,disable= (tab!=3)
	Button SaveFilter win = PreTreatmentPanel,disable= (tab!=3)
	SetVariable OutFolder win = PreTreatmentPanel,disable= (tab!=3)

End



//------------------------------------------------------------------------------------
//------------------------------------------------------------------------------------
Function PopMenuFilter(ctrlName,popNum,popStr) : PopupMenuControl
	String ctrlName
	Variable popNum
	String popStr
	
	String PathFolder="root:PreTreatmentParam:"

	NVAR FilterType_e=$PathFolder+"FilterType_e"	
	NVAR FilterOption_e=$PathFolder+"FilterOption_e"
	NVAR Multi_e=$PathFolder+"Multiplicity_e"
	NVAR Selectedfilter_e=$PathFolder+"SelectFilter_e"

	NVAR FilterType_i=$PathFolder+"FilterType_i"
	NVAR FilterOption_i=$PathFolder+"FilterOption_i"
	NVAR Multi_i=$PathFolder+"Multiplicity_i"
	NVAR Selectedfilter_i=$PathFolder+"SelectFilter_i"
	Variable pastvalue

	strswitch (ctrlName)
		case "IsCoincF_e":
			If (popNum>1)
				Filtertype_e=(FilterType_e|1)
			Else
				Filtertype_e=(FilterType_e&254)
			Endif
			Multi_e=popNum-1
			break
		case "Filter_e":
			SelectedFilter_e=popNum
			PopGetFilter(popNum,PathFolder,"_e")
			
			break
		case "Combine_e":
			pastvalue=(FilterOption_e&193)
			if (popnum>1)
				FilterOption_e=2^(popNum-1)+pastvalue
			else
				FilterOption_e=pastvalue
			endif
			break
		case "IsCoincF_i":
			If (popNum>1)
				Filtertype_i=(FilterType_i|1)
			Else
				Filtertype_i=(FilterType_i&254)
			Endif
			Multi_i=popNum-1
			break
		case "Filter_i":
			SelectedFilter_i=popNum
			PopGetFilter(popNum,PathFolder,"_i")
			
			break
		case "Combine_i":
			pastvalue=(FilterOption_i&193)
			if (popnum>1)
				FilterOption_i=2^(popNum-1)+pastvalue
			else
				FilterOption_i=pastvalue
			endif
			break
	endswitch
End

//------------------------------------------------------------------------------------
Function CheckFilter(ctrlName,checked) : CheckBoxControl
	String ctrlName
	Variable checked
	
	String PathFolder="root:PreTreatmentParam:"
	NVAR FilterType_e=$PathFolder+"FilterType_e"
	NVAR FilterType_i=$PathFolder+"FilterType_i"
	NVAR FilterOption_e=$PathFolder+"FilterOption_e"
	NVAR FilterOption_i=$PathFolder+"FilterOption_i"

	strswitch (ctrlName)
		case "IsTimeF_e":
			Filtertype_e=FilterType_e%^(2^1)
			break
		case "IsSpatialXF_e":
			Filtertype_e=FilterType_e%^(2^2)
			break
		case "IsSpatialYF_e" :
			Filtertype_e=FilterType_e%^(2^3)
			break
		case "IsRadiusF_e" :
			Filtertype_e=FilterType_e%^(2^4)
			break 
		case "IsAngleF_e" :
			Filtertype_e=FilterType_e%^(2^5)
			break
		case  "IsMultiCoinF_e" :
			Filtertype_e=FilterType_e%^(2^7)
			break   
		case  "Filter_ei" :
			FilterOption_e=FilterOption_e%^(2^7)
			break   
		case  "Filter_ee" :
			FilterOption_e=FilterOption_e%^(2^6)
			break   
		case "IsTimeF_i":
			Filtertype_i=FilterType_i%^(2^1)
			break
		case "IsSpatialXF_i":
			Filtertype_i=FilterType_i%^(2^2)
			break
		case "IsSpatialYF_i" :
			Filtertype_i=FilterType_i%^(2^3)
			break
		case "IsRadiusF_i": 
			Filtertype_i=FilterType_i%^(2^4)
			break 
		case "IsAngleF_i" :
			Filtertype_i=FilterType_i%^(2^5)
			break
		case  "IsMultiCoinF_i" :
			Filtertype_i=FilterType_i%^(2^7)
			break   
		case  "Filter_ie" :
			FilterOption_i=FilterOption_i%^(2^7)
			break   
		case  "Filter_ii" :
			FilterOption_i=FilterOption_i%^(2^6)
			break   

	endswitch
End
//------------------------------------------------------------------------------------
Function ButtonFilter(ctrlName) : ButtonControl
	String ctrlName
	String PathFolder="root:PreTreatmentParam:"

	NVAR Selectedfilter_e=$PathFolder+"SelectFilter_e"
	NVAR Selectedfilter_i=$PathFolder+"SelectFilter_i"
	NVAR FilterOption_e=$PathFolder+"FilterOption_e"
	NVAR FilterOption_i=$PathFolder+"FilterOption_i"

	strswitch (ctrlName)
		case "CalculeFilter":
			DoFilter(PathFolder)
			DoAuto(PathFolder)
			break
		case "PlotEvents":
			Execute("DoFilterGraph()")
			break 
		case "PlotRefresh":
			Execute("RefreshFilterGraph()")
			break 
		case "SetF_e":
			PopSetFilter(Selectedfilter_e, PathFolder,"_e")
			break
		case "CalculeFilter_e":
			DoFilter_e(PathFolder)
			DoAuto(PathFolder)			
			break
		case "SetF_i":
			PopSetFilter(Selectedfilter_i, PathFolder,"_i")
			break		
		case "CalculeFilter_i":
			DoFilter_i(PathFolder)
			DoAuto(PathFolder)			
			break	
		case "HidePanel":
			KillPreTreatmentPanel()
			break
		case "disp_e":
			DoFetch_e(PathFolder)
			Execute("DoFetchGraph(\"e1\")")
			break
		case "disp_i":
			DoFetch_i(PathFolder)
			Execute("DoFetchGraph(\"i1\")")
			break	
		case "fetch_ei":
			DoFetch_e(PathFolder)
			DoFetch_i(PathFolder)
			break			
	endswitch
End

//------------------------------------------------------------------------------------
Function PopGetFilter(popNum,Pathfolder,suffix)
	Variable popNum
	String PathFolder, Suffix
	WAVE Valmin=$Pathfolder+"MinVal"+Suffix
	WAVE Valmax=$Pathfolder+"MaxVal"+Suffix

	Switch (popNum)
		case 1:
			WAVE Tmin=$Pathfolder+"T_min"+Suffix
			WAVE Tmax=$Pathfolder+"T_max"+Suffix
			ValMin = Tmin
			ValMax = Tmax
			break
		case 2 :
			WAVE Xmin=$Pathfolder+"X_min"+Suffix
			WAVE Xmax=$Pathfolder+"X_max"+Suffix
			ValMin = Xmin
			ValMax = Xmax
			break
		case 3:
			WAVE Ymin=$Pathfolder+"Y_min"+Suffix
			WAVE Ymax=$Pathfolder+"Y_max"+Suffix
			ValMin = Ymin
			ValMax = Ymax
			break
		case 4:
			WAVE Rmin=$Pathfolder+"R_min"+Suffix
			WAVE Rmax=$Pathfolder+"R_max"+Suffix
			ValMin = Rmin
			ValMax = Rmax
			break
		case 5:
			WAVE Anglemin=$Pathfolder+"Angle_min"+Suffix
			WAVE Anglemax=$Pathfolder+"Angle_max"+Suffix
			ValMin = Anglemin
			ValMax = Anglemax
			break
	EndSwitch
End

//------------------------------------------------------------------------------------
Function PopSetFilter(popNum,pathfolder,suffix)
	Variable popNum
	String PathFolder, Suffix
	WAVE Valmin=$Pathfolder+"MinVal"+Suffix
	WAVE Valmax=$Pathfolder+"MaxVal"+Suffix

	Switch (popNum)
		case 1:
			WAVE Tmin=$Pathfolder+"T_min"+Suffix
			WAVE Tmax=$Pathfolder+"T_max"+Suffix
			Tmin= ValMin 
			Tmax= ValMax 
			break
		case 2 :
			WAVE Xmin=$Pathfolder+"X_min"+Suffix
			WAVE Xmax=$Pathfolder+"X_max"+Suffix
			Xmin= ValMin 
			Xmax= ValMax 
			break
		case 3:
			WAVE Ymin=$Pathfolder+"Y_min"+Suffix
			WAVE Ymax=$Pathfolder+"Y_max"+Suffix
			Ymin = ValMin 
			Ymax = ValMax
			break
		case 4:
			WAVE Rmin=$Pathfolder+"R_min"+Suffix
			WAVE Rmax=$Pathfolder+"R_max"+Suffix
			Rmin = ValMin
			Rmax = ValMax 
			break
		case 5:
			WAVE Anglemin=$Pathfolder+"Angle_min"+Suffix
			WAVE Anglemax=$Pathfolder+"Angle_max"+Suffix
			AngleMin = ValMin 
			AngleMax =ValMax 
			break
	EndSwitch
End